/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.io;

import java.io.*;
import edu.emory.mathcs.backport.java.util.concurrent.*;

/**
 * Input source that is both redirectible and supports timeout read.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface TimedRedirectibleInput extends TimedInput, RedirectibleInput {

    /**
     * Reads with timeout and redirects up to the <code>len</code> bytes of
     * data to a specified output stream. Returns the number of bytes actually
     * redirected.
     * If nonzero bytes is requested but no data is available within the
     * specified timeout and the stream is not at EOF, TimeoutException is
     * thrown.
     *
     * @param dest the destination stream
     * @param len the maximum number of bytes to redirect
     * @param timeout the maximum number of milliseconds to wait before data
     *                is available
     * @return number of bytes actually redirected
     *
     * @throws IOException if IOException occurs
     * @throws TimeoutException if timeout occurs before data is available
     */
    int timedRedirect(OutputStream dest, int len, long timeout)
        throws IOException, TimeoutException;
}
